<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EstadoLiquidacion extends Model 
{

    protected $table = 'estado_liquidaciones';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name');
    protected $visible = array('name');

    public function liquidaciones()
    {
        return $this->hasMany('EstadoLiquidacionLiquidacion', 'estado_liquidacion_id');
    }

}